<?php

if (!function_exists ('is_admin'))
{
	header('Status: 403 Forbidden');
	header('HTTP/1.1 403 Forbidden');
	exit();
}
elseif (!class_exists('OnPageSEOAdmin'))
{
	class OnPageSEOAdmin
	{
		/**
		 * Variables
		 */

		var $postMetaDataName = 'onpageseo_post_meta_data';
		var $options = array();
		var $developerOptions = array();
		var $pagehook;
		var $postID;
		var $postMeta = array();
		var $totalScore = 0;
		var $keywordDensity = 0;
		var $minimumScore = 70;
		var $postRecency = '3 months';
		var $update;
		var $license;
		var $licenseHide = 0;
		var $h1 = array();
		var $h2 = array();
		var $h3 = array();



		/**
		 * PHP 4 constructor (for backwards compatibility)
		 *
		 * @param	array	$args
		 * @return	bool	true
		 */

		function OnPageSEOAdmin($args)
		{
			$this->__construct($args);
			return;
		}



		/**
		 * PHP 5 constructor
		 *
		 * @param	array	$args
		 * @return	void
		 */

		function __construct($args)
		{
			extract($args);

			// Sanitize Post ID
			$this->sanitizePostID();

			// Get Options
			if(!$this->options)
			{
				$this->options = $this->getOptions();
			}

			// Get Update Information
			$this->getUpdate();

			// Get License Information
			$this->getLicense();

			// Options Menu
			add_action('admin_menu', array(&$this,'adminMenu'));

			// Register Options
			add_action('admin_init', array(&$this, 'optionsInit'));

			// Enqueue Scripts
			add_action('admin_enqueue_scripts', array(&$this, 'enqueueScripts'));

			// Automatic Decorations (Admin-Side)
			if(isset($this->options['decoration_type']) && (strlen(trim($this->options['decoration_type'])) > 0) && ($this->options['decoration_type'] == 'admin'))
			{
				add_filter('wp_insert_post_data', array(&$this,'automaticDecorations'), 10, 2);
			}

			// Save Post/Page
			add_action('save_post', array(&$this, 'saveMetaData'), 10, 2);

			// Modify Post Columns
			add_action('manage_posts_custom_column', array(&$this, 'displayEditColumns'), 10, 2);
			add_filter('manage_posts_columns', array(&$this, 'addEditColumns'));

			// Modify Page Columns
			add_action('manage_pages_custom_column', array(&$this, 'displayEditColumns'), 10, 2);
			add_filter('manage_pages_columns', array(&$this, 'addEditColumns'));

			// Add Meta Boxes
			if(!$this->license->isLicenseError())
			{
				add_action('admin_menu', array(&$this,'addMetaBoxes'));
			}

			// Check For Updates
			add_action('after_plugin_row', array(&$this, 'checkForUpdates'));
		}



		function getUpdate()
		{
			// Include Update Class
			require_once('onpageseo-admin-update.php');

			// Initialize Update Object
			$this->update = new OnPageSEOUpdate(&$this->options);
		}



		function checkForUpdates($plugin)
		{
			if(strpos($plugin, OPSEO_PREFIX) !== false)
				$this->update->getUpdateInfo(1);
		}



		function getLicense()
		{
			// Include License Class
			require_once('onpageseo-admin-license.php');

			// Initialize License Object
			$this->license = new OnPageSEOLicense(&$this->options);
		}



		/**
		 * Creates main plugin options when plugin gets activated
		 *
		 * @param	void
		 * @return	void
		 */

		function activatePlugin()
		{
			// Get Options
			$this->options = $this->getOptions();
		}



		/**
		 * Get main plugin options (or add default values if not found)
		 *
		 * @param	void
		 * @return	array	$options
		 */

		function getOptions()
		{
			$options = get_option(OPSEO_PREFIX.'_options');

			// Options Exist
			if($options)
			{
				// Validate Required Options
				$options = $this->validateRequiredOptions($options);
				$update = $options['temp_update'];
				unset($options['temp_update']);

				// Update Options If Necessary
				if($update) { update_option(OPSEO_PREFIX.'_options', $options); }
			}
			// No Options Exist - Set Default
			else
			{
				$options = $this->getDefaultOptions();
				add_option(OPSEO_PREFIX.'_options', $options);
			}

			// Get Developer Options
			if(!$this->licenseHide) { $this->licenseHide = get_option(OPSEO_PREFIX.'_license_hide'); }

			return($options);
		}



		/**
		 * Get main plugin developer options
		 *
		 * @param	void
		 * @return	array	$options
		 */

		function getDeveloperOptions()
		{
			$options = get_option(OPSEO_PREFIX.'developer_options');

			// Create If Doesn't Exist
			if(!$options)
			{
				$options = array();
				add_option(OPSEO_PREFIX.'_options', $options);
			}

			return($options);
		}


		/**
		 * Verify required plugin options
		 *
		 * @param	void
		 * @return	bool
		 */

		function validateRequiredOptions($options)
		{
			$options['temp_update'] = 0;
			$requiredNumeric = array(
						"keyword_density_minimum"=>"2.0",
						"keyword_density_maximum"=>"5.5",
						"keyword_density_formula"=>"1",
						"description_meta_tag_maximum"=>"160",
						"post_content_length"=>"300",
						"title_length_minimum"=>"3",
						"title_length_maximum"=>"66",
						"posts_per_page"=>"20",
						"lsi_keyword_maximum_results"=>"50",
						"internal_links_posts_per_page"=>"10",
						"internal_images_per_page"=>"20",
						"request_timeout"=>"50"
						);

			$requiredAlpha = array(
						"lsi_keyword_region"=>"us|en",
						"lsi_keyword_sort"=>"frequency"
						);

			foreach($requiredNumeric as $key=>$value)
			{
				// Required Option Not Valid
				if( !isset($options[$key]) || (strlen(trim($options[$key])) == 0) || !is_numeric($options[$key]) )
				{
					// Set Default Option Value
					$options[$key] = $value;
					$options['temp_update'] = 1;
				}
			}

			foreach($requiredAlpha as $key=>$value)
			{
				// Required Option Not Valid
				if( !isset($options[$key]) || (strlen(trim($options[$key])) == 0) )
				{
					// Set Default Option Value
					$options[$key] = $value;
					$options['temp_update'] = 1;
				}
			}

			return($options);
		}



		/**
		 * Get the default plugin options
		 *
		 * @param	void
		 * @return	array	$options
		 */

		function getDefaultOptions()
		{
			$options = array(
					"bold_keyword"=>"1",
					"bold_style"=>"strong",
					"italic_keyword"=>"1",
					"italic_style"=>"em",
					"underline_keyword"=>"1",
					"underline_style"=>"fontdecorationunderline",
					"keyword_density_minimum"=>"2.0",
					"keyword_density_maximum"=>"5.5",
					"keyword_density_formula"=>"1",
					"description_meta_tag_maximum"=>"160",
					"post_content_length"=>"300",
					"title_length_minimum"=>"3",
					"title_length_maximum"=>"66",
					"posts_per_page"=>"20",
					"lsi_keyword_region"=>"us|en",
					"lsi_keyword_sort"=>"frequency",
					"lsi_keyword_maximum_results"=>"50",
					"internal_links_posts_per_page"=>"10",
					"internal_images_per_page"=>"20",
					"request_timeout"=>"50"
					);

			return($options);
		}



		/**
		 * Register plugin options
		 *
		 * @param	void
		 * @return	void
		 */

		function optionsInit()
		{
			// Process Actions/Commands
			if(current_user_can('edit_plugins'))
				$this->processActions();

			register_setting( OPSEO_PREFIX.'_settings', OPSEO_PREFIX.'_options' );
			register_setting( OPSEO_PREFIX.'_developer', OPSEO_PREFIX.'_developer_options' );
		}



		function enqueueScripts()
		{
			global $pagenow;
			if (false !== strpos($pagenow, 'post') || false !== strpos($pagenow, 'page'))
			{
				wp_enqueue_style('onpageseo-css', OPSEO_PLUGIN_URL.'/style/style.css');
				wp_enqueue_style('thickbox');
				wp_enqueue_script('jquery');
				wp_enqueue_script('jquery-ui-core');
				wp_enqueue_script('jquery-ui-draggable');
				wp_enqueue_script('jquery-ui-droppable');
				wp_enqueue_script('jquery-ui-sortable');
				wp_enqueue_script('jquery-ui-tabs');
				wp_enqueue_script('thickbox');
			}
		}



		/**
		 * Adds the "On-Page SEO" menu to the WP Admin Dashboard
		 *
		 * @param	void
		 * @return	void
		 */

		function adminMenu()
		{
			// Add a new top-level menu:
			add_menu_page(__('Easy WP SEO'), __('Easy WP SEO'), 'administrator', 'onpageseo-settings', array(&$this,'updatePluginOrSettings'));

			// Add a submenu to the custom top-level menu:
			$this->pagehook = add_submenu_page('onpageseo-settings', __('Settings'), __('Settings'), 'administrator', 'onpageseo-settings', array(&$this,'updatePluginOrSettings'));

			// Add a submenu to the custom top-level menu:
			add_submenu_page('onpageseo-settings', __('Manage Keywords'), __('Manage Keywords'), 'administrator', 'onpageseo-manage-keywords', array(&$this,'keywordsMenu'));

			add_action('load-'.$this->pagehook, array(&$this, 'settingsAdminMenu'));
		}




		/**
		 * Displays admin header for the "Settings" pages
		 *
		 * @param	string	$pageSlug
		 * @param	string	$pageName
		 * @return	void
		 */

		function adminHeader($pageSlug, $pageName)
		{
			include_once('templates/admin-header.php');
		}



		/**
		 * Display for the Update Plugin screen
		 *
		 * @param	void
		 * @return	void
		 */

		function updatePluginScreen()
		{?>
			<div class="wrap"><div id="icon-plugins" class="icon32"><br /></div>
			<h2>Upgrade Plugin</h2>

				<?php if(!$this->update->updatePlugin(OPSEO_PLUGIN_PATH)) { wp_die('install_failed', __('Plugin upgrade failed')); }?>

			</div>
		<?php }



		/**
		 * Display Update Plugin or Settings screen
		 *
		 * @param	void
		 * @return	void
		 */

		function updatePluginOrSettings()
		{
			// Update Plugin Screen
			if(isset($_REQUEST['action']) && $_REQUEST['action'] == 'upgrade') { $this->updatePluginScreen(); }
			// Settings Screen
			else { $this->settingsMenu(); }
		}



		/**
		 * Display for the "Settings" section of the "On-Page SEO" menu
		 *
		 * @param	void
		 * @return	void
		 */

		function settingsMenu()
		{
			if(!$this->license->isLicenseError()) { include_once('templates/admin-settings-menu.php'); }
			else { include_once('templates/admin-enter-license.php'); }
		}



		/**
		 * Display License information
		 *
		 * @param	void
		 * @return	void
		 */

		function licenseFooter()
		{
			include_once('templates/admin-license-footer.php');
		}



		/**
		 * Display Reset information
		 *
		 * @param	void
		 * @return	void
		 */

		function resetFooter()
		{
			include_once('templates/admin-reset-footer.php');
		}



		/**
		 * Options panel for the Settings menu
		 *
		 * @param	void
		 * @return	void
		 */

		function settingsAdminMenu()
		{
			wp_enqueue_style('jquery-ui-tabs-opseo-css', OPSEO_PLUGIN_URL.'/style/config.ui.all.css');
			wp_enqueue_script('jquery');
			wp_enqueue_script('jquery-ui-tabs');
			wp_enqueue_script('thickbox');
		}



		/**
		 * Display for the "Manage Keywords" section of the "On-Page SEO" menu
		 *
		 * @param	void
		 * @return	void
		 */

		function keywordsMenu()
		{
			if(!$this->license->isLicenseError()) { include_once('templates/admin-keywords-menu.php'); }
			else { include_once('templates/admin-enter-license.php'); }
		}



		/**
 		 * Generates the table for the admin module
 		 *
		 * @param  array	$cols		column headers for the table
		 * @param  array	$rows		multidemensional array containing all the rows
		 * @param  mixed	$msg		the message, if any, to add to bottom of the table
		 * @param  bool	$tfoot	whether to display the tfooter
		 * @param  bool	$add_break	whether to add a br tag at the bottom of the table
		 * @return string	$table
		 */

		function adminTable($cols, $rows, $msg = FALSE, $tfoot = TRUE, $add_break = FALSE)
		{
			$total_cols = count($cols);
			$total_rows = count($rows);

			$table = '<table class="widefat comments-box " cellspacing="0"><thead><tr>';
			$table_cols = '';
			for($i=0;$i<$total_cols;$i++)
			{
				//$table_cols .='<th>'.$cols[$i].'</th>';
				$table_cols .= $cols[$i];
			}

			$table .= $table_cols.'</tr></thead>';
			if($tfoot)
			{
				$table .= '<tfoot><tr>'.$table_cols.'</tr></tfoot>';
			}

			if($total_rows == 0)
			{
				$table .= '<tr><td colspan="'.$total_cols.'" align="center">'.__('Nothing Found','onpageseo').'</td></tr>';
			}
			else
			{
				for($i=0;$i<$total_rows;$i++)
				{
					$table .= '<tr>';
					$total_cols = count($rows[$i]);
					for($k=0;$k<$total_cols;$k++)
					{
						//$table .='<td>'.$rows[$i][$k].'</td>';
						$table .= $rows[$i][$k];
					}
					$table .= '<tr>';
				}
			}

			$table .= '<tbody id="the-comment-list" class="list:comment"></tbody></table>';

			if($add_break)
			{
				$table .= '<br />';
			}

			return $table;
		}




		/**
		 * Displays the Score meta box on the edit post/page screen
		 *
		 * @param	void
		 * @return	void
		 */

		function addMetaBoxes()
		{
			$metaData = get_post_meta($this->postID, $this->postMetaDataName, true);

			// Post Meta Data Already Exists
			if(!empty($metaData))
			{
				$this->postMeta = $metaData;
				$this->totalScore = $this->postMeta['score'];
			}

			if( function_exists('add_meta_box'))
			{
				foreach($this->getPostTypes() as $type)
				{
					add_meta_box('onpageseo_post', __('Easy WP SEO','onpageseo'), array(&$this, 'scoreMetaBox'), $type, 'side', 'high' );
				}
			}
		}



		/**
		 * Returns all the registered post types
		 *
		 * @param	void
		 * @return	array
		 */

		function getPostTypes()
		{
			if(function_exists('get_post_types')) { return(get_post_types('','names')); }
			else { return(array('post','page')); }
		}



		/**
		 * Displays the Score meta box on the edit post/page screen
		 *
		 * @param	void
		 * @return	void
		 */

		function scoreMetaBox()
		{
			include_once('templates/admin-score-metabox.php');
		}



		/**
		 * Returns bullet class name for Score meta box
		 *
		 * @param	bool	$val
		 * @return	string
		 */

		function getMarkClass($val)
		{
			if($val){ return('onpageseoscorelitrue'); }
			else { return('onpageseoscorelifalse'); }
		}



		/**
		 * Returns bullet class name for Score meta box
		 *
		 * @param	bool	$val
		 * @return	string
		 */

		function getTotalScoreColorClass($score)
		{
			if($score >= $this->minimumScore) { return('onpageseogreenscore'); }
			else { return('onpageseoredscore'); }
		}



		/**
		 * Returns total score/keyword density class name for Score meta box
		 *
		 * @param	int	$score
		 * @return	string
		 */

		function getKeywordDensityColorClass($score)
		{
			if($score <= $this->options['keyword_density_maximum'] && $score >= $this->options['keyword_density_minimum']) { return('onpageseogreenscore'); }
			else { return('onpageseoredscore'); }
		}



		/**
		 * Returns total score/keyword density class name for Score meta box
		 *
		 * @param	int	$postID
		 * @return	array
		 */

		function getScoreKeyword($postID)
		{
			$metaData = get_post_meta($postID, $this->postMetaDataName, true);
			$mainKeyword = '';
			$totalScore = '';

			if(is_array($metaData['onpageseo_global_settings']))
			{
				$mainKeyword = $metaData['onpageseo_global_settings']['MainKeyword'];
				$totalScore = $metaData[trim(strtolower($mainKeyword))]['TotalScore'];
			}

			return(array($totalScore,$mainKeyword));
		}



		/**
		 * Saves post meta data (or deletes previous post meta data if keyword does not exist)
		 *
		 * @param	void
		 * @return	void
		 */

		function saveMetaData($postID)
		{
			// Save Only Once
			if(false !== (wp_is_post_autosave($postID) || wp_is_post_revision($postID))) { return; }

			if(current_user_can('edit_posts'))
			{
				// Keyword Exists
				if(isset($_REQUEST['mainkeyword']) && (strlen(trim($_REQUEST['mainkeyword'])) > 0))
				{
					// Analyze Post
					$this->analyzePost();

					// Update Post Meta Data
					update_post_meta($this->postID, $this->postMetaDataName, $this->postMeta);
				}
				// Update Secondary Keywords
				elseif(isset($_REQUEST['allsecondarykeywords']) && (strlen(trim($_REQUEST['allsecondarykeywords'])) > 0))
				{
					// Main Keyword
					$_REQUEST['mainkeyword'] = '';

					// Analyze Post
					$this->analyzePost();

					// Update Post Meta Data
					update_post_meta($this->postID, $this->postMetaDataName, $this->postMeta);
				}
				// Delete Old Meta Data if Keyword Does Not Exist
				elseif(isset($this->postMeta['onpageseo_global_settings']['MainKeyword']))
				{
					delete_post_meta($this->postID, $this->postMetaDataName);
				}
			}
			else
			{
				wp_die('You do not have permission to edit this post.');
			}
		}



		function analyzePost()
		{
			$permalink = '';

			// Get Current Post Information
			$currentPost = get_post($this->postID);

			// Check Post Status
			$postStatus = $currentPost->post_status;

			// Post/Page Not Published
			if($postStatus != 'publish')
			{
				// Change Post Status To "Publish"
				$this->updatePost($this->postID, 'post_status', 'publish');

				// Custom Permalink Structure
				if(get_option('permalink_structure'))
				{
					// Save Current Post Name
					$postName = $currentPost->post_name;

					// No Post Name Saved or Is Numeric (Possible 404 Errors)
					if(!trim($postName) || is_numeric(trim($postName)))
					{
						// Set Post ID As Title If Post Title Does Not Exist
						if(!$currentPost->post_title)
							$currentPost->post_title = (strlen(trim($this->postID)) > 0) ? 'draft'.$this->postID : 'draft';

						// Does Post Name Already Exist In DB
						global $wpdb;
						$incr = -1;

						do {
							// Sanitize Title With Dashes
							$postName = sanitize_title_with_dashes($currentPost->post_title);

							++$incr;
							if($incr) { $postName .= '-'.$incr; }

						} while($wpdb->get_row( $wpdb->prepare("SELECT post_title FROM $wpdb->posts WHERE post_name = '" . $postName . "'", 'ARRAY_A') ));


						// Update Post Name
						$this->updatePost($this->postID, 'post_name', $postName);

						$permalink = $this->addTrailingCharacter(get_bloginfo('wpurl'), '/') . $postName;
					}
					else { $permalink = $this->addTrailingCharacter(get_bloginfo('wpurl'), '/') . $currentPost->post_name; }
				}
				// Default Permalink Structure
				else { $permalink = get_permalink($this->postID); }

			}
			else { $permalink = get_permalink($this->postID); }


			//$permalink = get_permalink($this->postID);
			$domainName = parse_url($permalink, PHP_URL_HOST);


			// Request Post/Page URL
			if(!class_exists('WP_Http'))
				include_once( ABSPATH . WPINC. '/class-http.php' );

			$request = new WP_Http;

			// Set Timeout
			$requestArgs = array(
				'timeout'=>$this->options['request_timeout']
			);

			$result = $request->request($permalink, $requestArgs);

			// Error? Die and Display Error Message
			if(is_wp_error($result))
			{
				wp_die('The web server\'s connection was too slow. Go to '.OPSEO_NAME.' -> Settings -> Miscellaneous Settings and set the "Request Timeout" setting to a higher number.','Easy WP SEO Error');
			}

			// Success
			if($result['response']['code']=='200')
			{
				// UnTexturize
				$result['body'] = $this->unTexturize($result['body']);
			}

			// Get Keywords
			$_REQUEST['allsecondarykeywords'] = trim(preg_replace('/|||$/', '', stripslashes(trim($_REQUEST['allsecondarykeywords']))));
			$keywords = explode('|||', $_REQUEST['allsecondarykeywords']);
			array_unshift($keywords, $_REQUEST['mainkeyword']);
			for($i = 0; $i < sizeof($keywords); $i++)
			{
				if(!isset($keywords[$i]) || (strlen(trim($keywords[$i])) == 0))
				{
					unset($keywords[$i]);
				}
				else
				{
					$keywords[$i] = str_replace('"','',$keywords[$i]);
				}
			}

			// Clear Previous Entries
			$this->postMeta = array();

			// Main Keyword Check
			$mainKeywordCheck = 0;

			for($i = 0; $i < sizeof($keywords); $i++)
			{
				// Check If Blank Primary Keyword With Secondary Keywords
				if((strlen(trim($_REQUEST['mainkeyword'])) == 0) && !$mainKeywordCheck){$i+=1; $mainKeywordCheck+=1;}

				// Main Keyword
				$keyword = stripslashes(trim($keywords[$i]));
				$kwkey = strtolower($keyword);
				$this->postMeta[$kwkey]['Keyword'] = $keyword;

				// Keyword RegEx
				$regex = '/\b'.$keyword.'\b/is';
				$strippedKeyword = $keyword;
				$replaceChars = 'jEsdfSDF';
				$stripped = 0;

				// Keyword Contains Non-Alphanumeric Characters
				if(preg_match('/[^\w\d\s]/', $keyword))
				{
					// Solves Word Boundary Issue With Non-Alphanumeric Characters (At Beginning or End)
					$strippedKeyword = preg_replace('/[^\w\d\s]/i', $replaceChars, $keyword);
					$regex = '/\b'.$strippedKeyword.'\b/is';
					$stripped = 1;
				}

				$keywordWords = str_word_count($keyword);

				// Entire HTML Document
				$strippedBody = $result['body'];

				// Replace Non-Alphanumeric Characters
				if($stripped) { $strippedBody = preg_replace('/'.$keyword.'/i', $strippedKeyword, $strippedBody); }



				// Permalink
				// Delete Everything But Word Characters And Spaces
				$permalink = trim(preg_replace('/[^\w\d\s]/', ' ', $permalink));
				$permalinkKeyword = trim(preg_replace('/[^\w\d\s]+/', ' ', $keyword));
				$this->postMeta[$kwkey]['Permalink'] = $this->checkFactor('/'.$permalinkKeyword.'/i', &$permalink);

				// Title
				list($keywordTitle, $keywordTitleBeginning) = $this->analyzeTag('title', $strippedBody, $strippedKeyword, 1);

				// Keyword in Title
				$this->postMeta[$kwkey]['KeywordTitle'] = $keywordTitle;

				// Keyword at Beginning of Title
				$this->postMeta[$kwkey]['KeywordTitleBeginning'] = $keywordTitleBeginning;

				list($titleWords, $titleChars) = $this->analyzeTagLength('title', $strippedBody, $strippedKeyword, 1);

				// Title Length (# Words)
				$this->postMeta[$kwkey]['TitleWords'] = ($titleWords >= $this->options['title_length_minimum']) ? 1 : 0;

				// Title Characters
				$this->postMeta[$kwkey]['TitleChars'] = ($titleChars >= 1 && $titleChars <= $this->options['title_length_maximum']) ? 1 : 0;


				// Meta Tags

					// Description
					list($descriptionMetaTag, $descriptionMetaTagBeginning) = $this->analyzeMetaTag('description', $strippedBody, $strippedKeyword, 1);

					$this->postMeta[$kwkey]['DescriptionMetaTag'] = $descriptionMetaTag;

					list($descriptionMetaTagWords, $descriptionMetaTagChars) = $this->analyzeMetaTagLength('description', $strippedBody, $strippedKeyword);

					// Description Length
					$this->postMeta[$kwkey]['DescriptionMetaTagLength'] = ($descriptionMetaTagChars <= $this->options['description_meta_tag_maximum'] && $descriptionMetaTagChars >= 1) ? '1' : '0';

					// Description Keyword At Beginning
					$this->postMeta[$kwkey]['DescriptionMetaTagBeginning'] = $descriptionMetaTagBeginning;

					// Keywords
					$this->postMeta[$kwkey]['KeywordsMetaTag'] = $this->analyzeMetaTag('keywords', $strippedBody, $strippedKeyword);



				// Post Content
				$content = stripslashes($currentPost->post_content);
				$strippedContent = $this->unTexturize($content);

					// Strip Tags and Replace Non-Alphanumeric Characters
					if($stripped) { $strippedContent = preg_replace('/[^\w\d\s]/i', $replaceChars, strip_tags($strippedContent)); }
					// Just Strip Tags
					else { $strippedContent = strip_tags($strippedContent); }


					// Post Count Number of Words (250+)
					$postWords = str_word_count($strippedContent);
					$this->postMeta[$kwkey]['PostWords'] = ($postWords >= $this->options['post_content_length']) ? 1 : 0;

					// Keyword Density
					$keywordInstances = preg_match_all($regex, $strippedContent, $matches);



					// At Least One Keyword
					if($keywordInstances)
					{
						// First Keyword Density Formula
						if($this->options['keyword_density_formula'] == 1)
						{
							$this->postMeta[$kwkey]['KeywordDensityScore'] = ($keywordInstances / $postWords) * 100;
						}
						// Second Keyword Density Formula
						else
						{
							$this->postMeta[$kwkey]['KeywordDensityScore'] = ($keywordInstances / ($postWords / $keywordWords)) * 100;
						}
					}
					// No Keyword Matches (Ensure No Division By Zero Errors)
					else { $this->postMeta[$kwkey]['KeywordDensityScore'] = 0; }

					$this->postMeta[$kwkey]['KeywordDensityScore'] = number_format($this->postMeta[$kwkey]['KeywordDensityScore'], 2, '.', ',');
					$this->postMeta[$kwkey]['KeywordDensity'] = ($this->postMeta[$kwkey]['KeywordDensityScore'] >= $this->options['keyword_density_minimum']&& $this->postMeta[$kwkey]['KeywordDensityScore'] <= $this->options['keyword_density_maximum']) ? 1 : 0;



					// Keyword In First 50-100 Words
					preg_match("/^(\S+\s+){0,100}/", $strippedContent, $first100words);
					$this->postMeta[$kwkey]['First100Words'] = $this->checkFactor($regex, &$first100words[0]);


					// Keyword In Last 50-100 Words
					$last100wordsarr = str_word_count(trim($strippedContent),1);
					$last100wordstemp = array();
					$last100words = '';

					// More Than Or Equal To 100 Words
					if(sizeof($last100wordsarr) >= 99)
					{
						$arrStart = sizeof($last100wordsarr) - 99;
						for($z = $arrStart; $arrStart < sizeof($last100wordsarr); $arrStart++) { $last100wordstemp[] = $last100wordsarr[$arrStart]; }
						$last100words = implode(' ', $last100wordstemp);
						$this->postMeta[$kwkey]['Last100Words'] = $this->checkFactor($regex, &$last100words);

					}
					// Less Than 100 Words
					else
					{
						if($this->postMeta[$kwkey]['First100Words']){ $this->postMeta[$kwkey]['Last100Words'] = 1; }
						else{ $this->postMeta[$kwkey]['Last100Words'] = 0; }
					}











					// External Link Anchor Text
					$this->postMeta[$kwkey]['ExternalAnchorText'] = $this->analyzeAnchorTag('external', $strippedBody, $strippedKeyword, $domainName);


					// Internal Link Anchor Text
					$this->postMeta[$kwkey]['InternalAnchorText'] = $this->analyzeAnchorTag('internal', $strippedBody, $strippedKeyword, $domainName);












					// Header Tags
					list($H1, $H1Beginning) = $this->analyzeTag('h1', $strippedBody, $strippedKeyword, 1);
					$this->postMeta[$kwkey]['H1'] = $H1;
					$this->postMeta[$kwkey]['H1Beginning'] = $H1Beginning;
					$this->postMeta[$kwkey]['H2'] = $this->analyzeTag('h2', $strippedBody, $strippedKeyword);
					$this->postMeta[$kwkey]['H3'] = $this->analyzeTag('h3', $strippedBody, $strippedKeyword);


					// IMG Tags
					$this->postMeta[$kwkey]['ImageALT'] = $this->analyzeImageTag($strippedBody, $strippedKeyword);


					// Bold
					$this->postMeta[$kwkey]['Bold'] = $this->analyzeBoldDecoration($strippedBody, $strippedKeyword);

					// Italic
					$this->postMeta[$kwkey]['Italic'] = $this->analyzeItalicDecoration($strippedBody, $strippedKeyword);

					// Underline
					$this->postMeta[$kwkey]['Underline'] = $this->analyzeUnderlineDecoration($strippedBody, $strippedKeyword);


				// Calculate Score
				$totalCount = $this->postMeta[$kwkey]['KeywordTitle'] + $this->postMeta[$kwkey]['KeywordTitleBeginning'] + $this->postMeta[$kwkey]['TitleWords'] + $this->postMeta[$kwkey]['TitleChars'] + $this->postMeta[$kwkey]['DescriptionMetaTag'] + $this->postMeta[$kwkey]['KeywordsMetaTag'] + $this->postMeta[$kwkey]['PostWords'] + $this->postMeta[$kwkey]['KeywordDensity'] + $this->postMeta[$kwkey]['H1'] + $this->postMeta[$kwkey]['H1Beginning'] + $this->postMeta[$kwkey]['H2'] + $this->postMeta[$kwkey]['H3'] + $this->postMeta[$kwkey]['DescriptionMetaTagLength'] + $this->postMeta[$kwkey]['DescriptionMetaTagBeginning'] + $this->postMeta[$kwkey]['ImageALT'] + $this->postMeta[$kwkey]['Bold'] + $this->postMeta[$kwkey]['Italic'] + $this->postMeta[$kwkey]['Underline'] + $this->postMeta[$kwkey]['Permalink'] + $this->postMeta[$kwkey]['ExternalAnchorText'] + $this->postMeta[$kwkey]['InternalAnchorText'] + $this->postMeta[$kwkey]['First100Words'] + $this->postMeta[$kwkey]['Last100Words'];


				$this->postMeta[$kwkey]['TotalScore'] = $totalCount / 23 * 100;
				$this->postMeta[$kwkey]['TotalScore'] = number_format($this->postMeta[$kwkey]['TotalScore'], 2, '.', ',');

				// Main Keyword
				if(!$i) { $this->totalScore = $this->postMeta[$kwkey]['TotalScore']; }

			
			} // End of For Loop



			// Change Post Status
			if($postStatus != 'publish')
			{
				$this->updatePost($this->postID, 'post_status', $postStatus);
				$this->updatePost($this->postID, 'post_name', $postName);
			}

			// Global Settings

				// Main Keyword
				$this->postMeta['onpageseo_global_settings']['MainKeyword'] = str_replace('"','',stripslashes(trim($_REQUEST['mainkeyword'])));

				// Secondary Keywords
				$this->postMeta['onpageseo_global_settings']['SecondaryKeywords'] = str_replace('"','',stripslashes(trim($_REQUEST['allsecondarykeywords'])));



				// Readability Scores
				require_once('onpageseo-readability.php');
				$readability = new TextStatistics();

					// Flesch-Kincaid Reading Ease
					$this->postMeta['onpageseo_global_settings']['FleschEase'] = $readability->flesch_kincaid_reading_ease(strip_tags($content));

					// Flesch-Kincaid Reading Ease Level
					$this->postMeta['onpageseo_global_settings']['FleschLevel'] = $readability->flesch_kincaid_reading_ease_level($this->postMeta['onpageseo_global_settings']['FleschEase']);

					// Flesch-Kincaid Grade Level
					$this->postMeta['onpageseo_global_settings']['FleschGradeLevel'] = $readability->flesch_kincaid_grade_level(strip_tags($content));

					// Gunning-Fog Score
					$this->postMeta['onpageseo_global_settings']['GunningFogScore'] = $readability->gunning_fog_score(strip_tags($content));

					// Coleman-Liau Index
					$this->postMeta['onpageseo_global_settings']['ColemanLiauIndex'] = $readability->coleman_liau_index(strip_tags($content));

					// SMOG Index
					$this->postMeta['onpageseo_global_settings']['SMOGIndex'] = $readability->smog_index(strip_tags($content));

					// Automated Readability Index
					$this->postMeta['onpageseo_global_settings']['AutomatedReadabilityIndex'] = $readability->automated_readability_index(strip_tags($content));

				// Readability Statistics

					// Clean Text
					$readableContent = $readability->clean_text(strip_tags($content));

					// Sentence Count
					$this->postMeta['onpageseo_global_settings']['SentenceCount'] = (int)$readability->sentence_count(strip_tags($content));

					// Word Count
					$this->postMeta['onpageseo_global_settings']['WordCount'] = (int)$readability->word_count(strip_tags($content));

					// Average Words Per Sentence
					$this->postMeta['onpageseo_global_settings']['AverageWordsPerSentence'] = (int)$readability->average_words_per_sentence(strip_tags($content));

					// Average Syllables Per Word
					$this->postMeta['onpageseo_global_settings']['AverageSyllablesPerWord'] = number_format($readability->average_syllables_per_word(strip_tags($content)), 2, '.', '');

					// Number Of Words With Three+ Syllables (Complex Words)
					$this->postMeta['onpageseo_global_settings']['ComplexWordsNumber'] = (int)$readability->words_with_three_syllables(strip_tags($content));

					// Percentage Of Words With Three+ Syllables (Complex Words)
					$this->postMeta['onpageseo_global_settings']['ComplexWordsPercentage'] = number_format($readability->percentage_words_with_three_syllables(strip_tags($content)), 2, '.', '');

		}



		function updatePost($postID, $postKey, $postVar)
		{
			global $wpdb;
			$wpdb->query($wpdb->prepare("UPDATE $wpdb->posts SET $postKey='$postVar' WHERE ID='$postID'"));
		}



		function stripChars($content)
		{
			return preg_replace('/[^\w\- ]/i', '', html_entity_decode(strip_tags(stripslashes(trim($content))), ENT_QUOTES, get_bloginfo('charset')));
		}



		function selected($field, $value)
		{
			if(isset($_REQUEST[$field]) && $_REQUEST[$field] == $value)
				return ' selected="selected"';
		}



		function getMonthName($month)
		{
			$mon = array('', 'January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December');
			return $mon[(int)$month];
		}



		function checkKeyword()
		{
			return ((isset($_REQUEST['mainkeyword']) && (strlen(trim($_REQUEST['mainkeyword'])) > 0))  || (isset($this->postMeta[strtolower($this->postMeta['onpageseo_global_settings']['MainKeyword'])]['Keyword']) && (strlen(trim($this->postMeta[strtolower($this->postMeta['onpageseo_global_settings']['MainKeyword'])]['Keyword'])) > 0))) ? 1 : 0;
		}



		function checkFactor($pattern, &$content, $all=0)
		{
			$result = 0;
			if($all) { if(preg_match_all($pattern, &$content)) {$result = 1;} }
			else { if(preg_match($pattern, &$content)) {$result = 1;} }
			return($result);
		}





		function analyzeTag($tagname, $content, $keyword, $beginning="")
		{
			@$dom = new DOMDocument();
			@$dom->loadHTML(strtolower($content));
			@$xpath = new DOMXPath(@$dom);
			@$elements = $xpath->query('//'.$tagname.'[contains(., "'.strtolower($keyword).'")]');

			$result = 0;
			$begin = 0;
			$regex = '/\b'.$keyword.'\b/i';
			$regexBeginning = '/^'.$keyword.'\b/i';

			foreach ($elements as $e)
			{
				if(preg_match($regex, $e->nodeValue, $matches))
				{
					$result = 1;

					// Beginning
					if($beginning && !$begin)
					{
						if(preg_match($regexBeginning, trim($e->nodeValue), $matches))
						{
							$begin = 1;
						}
					}
				}
			}

			if($beginning) { return(array($result, $begin)); }
			else { return $result; }
		}



		function analyzeTagLength($tagname, $content, $keyword)
		{
			@$dom = new DOMDocument();
			@$dom->loadHTML(strtolower($content));
			@$xpath = new DOMXPath(@$dom);
			@$elements = $xpath->query('//'.$tagname);

			$words = 0;
			$chars = 0;

			foreach ($elements as $e)
			{
				$words = str_word_count(trim($e->nodeValue));
				$chars = strlen($e->nodeValue);
				if($tagname == 'title') { break; }
			}

			return(array($words, $chars));
		}



		function analyzeImageTag($content, $keyword)
		{
			@$dom = new DOMDocument();
			@$dom->loadHTML(strtolower($content));
			@$xpath = new DOMXPath(@$dom);
			@$elements = $xpath->query('//img[contains(@alt, "'.strtolower($keyword).'")]');

			$result = 0;
			$regex = '/\b'.$keyword.'\b/i';

			foreach ($elements as $e)
			{
				if(preg_match($regex, $e->getAttribute('alt'), $matches))
				{
					$result = 1;
				}
			}

			return $result;
		}



		function analyzeMetaTag($attribute, $content, $keyword, $beginning="")
		{
			@$dom = new DOMDocument();
			@$dom->loadHTML(strtolower($content));
			@$xpath = new DOMXPath(@$dom);
			@$elements = $xpath->query('//meta[contains(@name, "'.$attribute.'") and contains(@content, "'.strtolower($keyword).'")]');

			$result = 0;
			$begin = 0;
			$regex = '/\b'.$keyword.'\b/i';
			$regexBeginning = '/^'.$keyword.'\b/i';

			foreach ($elements as $e)
			{
				if(preg_match($regex, $e->getAttribute('content'), $matches))
				{
					$result = 1;

					// Beginning
					if($beginning && !$begin)
					{
						if(preg_match($regexBeginning, trim($e->getAttribute('content')), $matches))
						{
							$begin = 1;
						}
					}
				}
			}

			if($beginning) { return(array($result, $begin)); }
			else { return $result; }
		}



		function analyzeMetaTagLength($attribute, $content, $keyword)
		{
			@$dom = new DOMDocument();
			@$dom->loadHTML(strtolower($content));
			@$xpath = new DOMXPath(@$dom);

			@$elements = $xpath->query('//meta[contains(@name, "'.$attribute.'")]');

			$words = 0;
			$chars = 0;

			foreach ($elements as $e)
			{
				$words = str_word_count(trim($e->getAttribute('content')));
				$chars = strlen($e->getAttribute('content'));
			}

			return(array($words, $chars));
		}



		function analyzeBoldDecoration($content, $keyword)
		{
			@$dom = new DOMDocument();
			@$dom->loadHTML(strtolower($content));
			@$xpath = new DOMXPath(@$dom);
			@$elements = $xpath->query('//b[contains(., "'.strtolower($keyword).'")]|//strong[contains(., "'.strtolower($keyword).'")]|//span[contains(@style, "bold") and contains(., "'.strtolower($keyword).'")]');

			$result = 0;
			$regex = '/\b'.$keyword.'\b/i';

			foreach ($elements as $e)
			{
				$val = '';
				if(isset($e->nodeValue) && (strlen(trim($e->nodeValue)) > 0)) { $val = $e->nodeValue; }
				else { $val = $e->getAttribute('style'); }

				if(preg_match($regex, $val, $matches))
				{
					$result = 1;
				}
			}

			return $result;
		}



		function analyzeItalicDecoration($content, $keyword)
		{
			@$dom = new DOMDocument();
			@$dom->loadHTML(strtolower($content));
			@$xpath = new DOMXPath(@$dom);
			@$elements = $xpath->query('//i[contains(., "'.strtolower($keyword).'")]|//em[contains(., "'.strtolower($keyword).'")]|//span[contains(@style, "italic") and contains(., "'.strtolower($keyword).'")]');

			$result = 0;
			$regex = '/\b'.$keyword.'\b/i';

			foreach ($elements as $e)
			{
				$val = '';
				if(isset($e->nodeValue) && (strlen(trim($e->nodeValue)) > 0)) { $val = $e->nodeValue; }
				else { $val = $e->getAttribute('style'); }

				if(preg_match($regex, $val, $matches))
				{
					$result = 1;
				}
			}

			return $result;
		}



		function analyzeUnderlineDecoration($content, $keyword)
		{
			@$dom = new DOMDocument();
			@$dom->loadHTML(strtolower($content));
			@$xpath = new DOMXPath(@$dom);
			@$elements = $xpath->query('//u[contains(., "'.strtolower($keyword).'")]|//span[contains(@style, "underline") and contains(., "'.strtolower($keyword).'")]');

			$result = 0;
			$regex = '/\b'.$keyword.'\b/i';

			foreach ($elements as $e)
			{
				$val = '';
				if(isset($e->nodeValue) && (strlen(trim($e->nodeValue)) > 0)) { $val = $e->nodeValue; }
				else { $val = $e->getAttribute('style'); }

				if(preg_match($regex, $val, $matches))
				{
					$result = 1;
				}
			}

			return $result;
		}



		function analyzeAnchorTag($linkType, $content, $keyword, $domainName)
		{
			@$dom = new DOMDocument();
			@$dom->loadHTML(strtolower($content));
			@$xpath = new DOMXPath(@$dom);
			@$elements = $xpath->query('//a[contains(., "'.strtolower($keyword).'")]');

			$result = 0;
			$domainName = str_replace('/', '\/', $domainName);
			$regex = '/\b'.$keyword.'\b/i';

			foreach ($elements as $e)
			{
				if(preg_match($regex, $e->nodeValue, $matches))
				{
					// Internal
					if(preg_match('/^\/|'.$domainName.'/i', trim($e->getAttribute('href')), $matches))
					{
						if($linkType == 'internal') { $result = 1; }
					}
					// External
					else { if($linkType == 'external') { $result = 1; } }
				}
			}

			return $result;
		}


















		function checkHeaderTags($tag, $keyword, &$content, $beginning=0)
		{
			$result = 0;

			$pattern = '/<'.$tag.'[^>]*>(.*\b'.$keyword.'\b.*)<\/'.$tag.'>/siU';
			$pattern1 = '/<'.$tag.'[^>]*>(\b'.$keyword.'\b.*)<\/'.$tag.'>/siU';

			if($beginning) { $pattern = $pattern1; }

			if(preg_match($pattern, &$content, $matches))
			{
				$result = 1;
			}

			return $result;
		}


		function sanitizePostID()
		{
			if(isset($_REQUEST['post_ID']) && (strlen(trim($_REQUEST['post_ID'])) > 0))
				$this->postID = intval(stripslashes($_REQUEST['post_ID']));
			elseif(isset($_REQUEST['post']) && (strlen(trim($_REQUEST['post'])) > 0))
				$this->postID = intval(stripslashes($_REQUEST['post']));
		}



		function filterInput($data)
		{
			$data = trim(htmlentities(strip_tags($data)));

			if (get_magic_quotes_gpc())
				$data = stripslashes($data);

			$data = mysql_real_escape_string($data);

			return $data;
		}



		function unTexturize($content)
		{
			$content = str_replace('&#8216;', "'", $content); // '
			$content = str_replace('&#8217;', "'", $content); // '
			$content = str_replace('&#8242;', "'", $content); // '
			$content = str_replace('&#8220;', '"', $content); // 
			$content = str_replace('&#8221;', '"', $content); // 
			$content = str_replace('&#8243;', '"', $content); // "
			$content = str_replace('&#8211;', '--', $content); // testing
			$content = str_replace(' &#8212; ', ' -- ', $content); // test  ing
			$content = preg_replace('/(\w)&#8212;(\w)/', '$1---$2', $content); // test  ing
			$content = str_replace('&#8230;', '...', $content); // 
			$content = str_replace('&#215;', 'x', $content); // 
			$content = str_replace('&amp;', '&', $content); // &
			$content = str_replace('&#038;', '&', $content); // &
			$content = str_replace('&quot;', "'", $content); // '
			$content = str_replace('&#169;', '(c)', $content); // 
			$content = str_replace('&#174;', '(r)', $content); // 
			$content = str_replace('&Prime;', '"', $content); // "
			$content = str_replace('&prime;', "'", $content); // '

			return($content);
		}




		/**
		 * Ensure string ends with the specified character
		 *
		 * @param	$str	String to validate
		 * @return	$str
		 */

		function addTrailingCharacter($str, $char)
		{
			if (strlen($str) > 0)
			{
				if (substr($str, -1) !== $char) { return $str . $char; }
				else { return $str; }
			}
			else { return $char; }
		}




		/**
		 * Posts success message in WP Admin
		 *
		 * @param	string	$msg
		 */

		function alertMessage($msg)
		{
			echo "<div id='setting-error-settings_updated' class='updated settings-error'> 
			<p><strong>".$msg."</strong></p></div>";

		}



		/**
		 * Posts error message in WP Admin
		 *
		 * @param	string	$msg
		 */

		function errorMessage($msg)
		{
			echo "<div class='error'><p><strong>".$msg."</strong></p></div>";

		}



		function displayEditColumns($columns, $postID)
		{
			list($score,$keyword) = $this->getScoreKeyword($postID);

			switch ($columns)
			{
				case 'onpagescore':
					$color = ($score >= $this->minimumScore) ? 'green' : 'red';
					if ($score) {echo __('<span style="color:'.$color.';">'.$score.'%</span>'); }
					break;
				case 'mainkeyword':
					if ($keyword) {echo __($keyword); }
					break;
			}
		}



		function addEditColumns($columns)
		{
			$columns2 = array();
			$count=0;

			foreach($columns as $key=>$val)
			{
				// Insert Two Columns After "Author"
				if($count == 3)
				{
					$columns2['onpagescore'] = __('On-Page SEO Score');
					$columns2['mainkeyword'] = __('Primary Keyword');
					$columns2[$key] = $val;
				}
				else { $columns2[$key] = $val; }

				$count++;
			}

			return $columns2;
		}



		function processActions()
		{
			// Clear Keywords and Scores
			if(isset($_REQUEST[OPSEO_PREFIX.'_clear_all_keywords'])) { $this->clearAllKeywords(); }
			// Reset Options to Defaults
			elseif(isset($_REQUEST[OPSEO_PREFIX.'_reset_options'])) { $this->resetOptionsToDefault(); }
			// Uninstall Plugin
			elseif(isset($_REQUEST[OPSEO_PREFIX.'_uninstall_plugin'])) { $this->uninstallPlugin(); }
			// Hide License
			elseif(isset($_REQUEST[OPSEO_PREFIX.'_hide_license'])) { $this->hideLicense(); }
			// Import SEOPressor Keywords
			elseif(isset($_REQUEST[OPSEO_PREFIX.'_import_seopressor'])) { $this->importKeywords('seopressor'); }
			// Import ClickBump SEO! Keywords
			elseif(isset($_REQUEST[OPSEO_PREFIX.'_import_clickbump'])) { $this->importKeywords('clickbump'); }
			// Import BloggerHigh SEO Keywords
			elseif(isset($_REQUEST[OPSEO_PREFIX.'_import_bloggerhigh'])) { $this->importKeywords('bloggerhigh'); }
			// Import SEO Beast Keywords
			elseif(isset($_REQUEST[OPSEO_PREFIX.'_import_seobeast'])) { $this->importBeastKeywords(); }
		}



		function clearAllKeywords()
		{
			global $wpdb;
			$wpdb->query($wpdb->prepare("DELETE FROM $wpdb->postmeta WHERE meta_key='".$this->postMetaDataName."'"));
		}



		function resetOptionsToDefault()
		{
			// Get Old Options
			$oldOptions = get_option(OPSEO_PREFIX.'_options');

			// Get Default Options
			$options = $this->getDefaultOptions();

			// Save License Info
			$options['license_email'] = $oldOptions['license_email'];
			$options['license_serial'] = $oldOptions['license_serial'];

			// Save Default Options
			update_option(OPSEO_PREFIX.'_options', $options);
		}



		function uninstallPlugin()
		{
			global $wpdb;
			global $wp_filesystem;

			// Delete All Keywords and Scores
			$wpdb->query($wpdb->prepare("DELETE FROM $wpdb->postmeta WHERE meta_key='".$this->postMetaDataName."'"));

			// Delete All Plugin Options
			$wpdb->query($wpdb->prepare("DELETE FROM $wpdb->options WHERE option_name='".OPSEO_PREFIX."_options' OR option_name='".OPSEO_PREFIX."_license_check' OR option_name='".OPSEO_PREFIX."_update_check' OR option_name='".OPSEO_PREFIX."_license_hide'"));

			// Deactivate Plugin
			deactivate_plugins(OPSEO_PLUGIN_PATH, true);

			// Redirect
			$this->redirect('plugins.php?deactivate=true');
		}


		function hideLicense()
		{
			$options = update_option(OPSEO_PREFIX.'_license_hide', '1');
			$this->licenseHide = 1;
		}



		function importKeywords($plugin)
		{
			global $wpdb;

			// SEOPressor
			$meta_key = 'posts_rate_key';

			// ClickBump SEO!
			if($plugin == 'clickbump') { $meta_key = '_rseo_keyword'; }

			// BloggerHigh SEO
			elseif($plugin == 'bloggerhigh') { $meta_key = '_psoff_seo_keyword'; }

			$sql_query = "SELECT post_id,meta_value FROM $wpdb->postmeta WHERE meta_key='$meta_key'";
			$sql_result = $wpdb->get_results($wpdb->prepare($sql_query));

			foreach($sql_result as $row)
			{
				$metaData = get_post_meta($row->post_id, $this->postMetaDataName, true);

				// Import If Exists
				if(empty($metaData))
				{
					// Set Post ID
					$this->postID = $row->post_id;

					// Set Main Keyword
					$_REQUEST['mainkeyword'] = $row->meta_value;

					// Save Meta Data
					$this->saveMetaData($row->post_id);
				}
			}
		}


		function importBeastKeywords()
		{
			global $wpdb;
			$option_name = 'seo_beast_meta%';

			$sql_query = "SELECT option_name,option_value FROM $wpdb->options WHERE option_name LIKE 'seo_beast_meta%%' AND blog_id='$wpdb->blogid'";
			$sql_result = $wpdb->get_results($wpdb->prepare($sql_query));

			foreach($sql_result as $row)
			{
				// Extract Post ID
				preg_match('/seo_beast_meta([0-9]+)/i', $row->option_name, $matches);
				$postID = $matches[1];

				// Extract Keyword
				$optionValues = unserialize($row->option_value);
				$keyword = $optionValues['seob_mkwd'];

				if((isset($postID) && (strlen(trim($postID)) > 0)) && (isset($keyword) && (strlen(trim($keyword)) > 0)))
				{
					$metaData = get_post_meta($postID, $this->postMetaDataName, true);

					// Import If Exists
					if(empty($metaData))
					{
						// Set Post ID
						$this->postID = $postID;

						// Set Main Keyword
						$_REQUEST['mainkeyword'] = $keyword;

						// Save Meta Data
						$this->saveMetaData($postID);
					}
				}
			}
		}



		function automaticDecorations($content)
		{
			// Include Automatic Decoration Class
			include('onpageseo-admin-decoration.php');
			$decoration = new OnPageSEOAdminDecoration($this->options);

			$content['post_content'] = $decoration->contentHandler($content['post_content']);

			return($content);
		}


		function redirect($url)
		{
			header('Location:'.$url);
			exit;
		}

	}
}
