<?php
/*
Template Name: Contact Us Template
*/

//If the form is submitted
if(isset($_POST['rt_name'])) {

	//Check to see if the honeypot captcha field was filled in
	if(trim($_POST['checking']) !== '') {
		$captchaError = true;
	} else {
	
		//Check to make sure that the name field is not empty
		if(trim($_POST['rt_name']) === '') {
			$nameError = 'Please enter your name.';
			$hasError = true;
		} else {
			$name = trim($_POST['rt_name']);
		}
		
		//Check to make sure sure that a valid email address is submitted
		if(trim($_POST['rt_email']) === '')  {
			$emailError = 'Please enter your email address.';
			$hasError = true;
		} else if (!eregi("^[A-Z0-9._%-]+@[A-Z0-9._%-]+\.[A-Z]{2,4}$", trim($_POST['rt_email']))) {
			$emailError = 'You entered an invalid email address.';
			$hasError = true;
		} else {
			$email = trim($_POST['rt_email']);
		}
			
		//Check to make sure comments were entered	
		if(trim($_POST['rt_message']) === '') {
			$commentError = 'Please enter your message.';
			$hasError = true;
		} else {
			if(function_exists('stripslashes')) {
				$comments = stripslashes(trim($_POST['rt_message']));
			} else {
				$comments = trim($_POST['rt_message']);
			}
		}
			
		//If there is no error, send the email
		if(!isset($hasError)) {
			$phone=trim($_POST['rt_phone']);
			$emailTo = ''.get_option('rttheme_form_mail').'';
			$subject = 'Contact Form Submission from '.$name;
			$body = "Name: $name \n\nEmail: $email \n\nPhone: $phone \n\nComments: $comments";
			$headers = 'From: '.$name.' <'.$emailTo.'>' . "\r\n" . 'Reply-To: ' . $email;
			
			mail($emailTo, $subject, $body, $headers);

			$emailSent = true;

		}
	}
} 
get_header();
$page_footer_widget=get_post_meta($post->ID, 'rt_page_footer_widget', true);
$this_is_page=true;
?>
		<!-- sub page header-->
		<div id="sub_page_header">
			<div class="left">	
			<!-- Page navigation-->
				<div id="sub_nav">
					<!-- [rt-breadcrumb] -->
						<?php  rt_breadcrumb(); ?>
					<!--/ [rt-breadcrumb] -->
				</div>
			<!-- /Page navigation-->
			</div>
			<div class="right"></div>
		</div>
		<!-- /sub page header-->


		<div class="sub_page">

			<!-- page left -->
			<div class="page_left content">

			<h1><?php the_title(); ?></h1>

					<?php if (have_posts()) : while (have_posts()) : the_post();
						$current_post=$post->ID;
					?>
					<?php the_content(); ?>
					<?php  endwhile;endif; ?>


					<?php if(isset($emailSent) && $emailSent == true) { ?>
						<div class="ok">
							<br />
							<h1>Thanks, <?php echo $name;?></h1>
							<p>Your email was successfully sent. We will be in touch soon.</p>
						</div>
					<?php } ?>

					<?php if(isset($hasError) || isset($captchaError)) { ?>
						<div class="error2"><br /><i>There was an error submitting the form. <br /><?php echo $emailError;?></i></div>
					<?php } ?>


					<?php if(!isset($emailSent) && $emailSent != true) { ?>
								<div id="contact_form">
									<form action="" name="contact_form" id="validate_form" method="post">
											<ul>
												<li><label for="name">Your name: (*)</label><input id="name" type="text" name="rt_name" value="<?php if(isset($_POST['rt_name']))  echo $_POST['rt_name'];?>" class="required" /> <?php if($nameError != '') { ?><?php echo $nameError;?><?php } ?></li>
												<li><label for="email">Your Email: (*)</label><input id="email" type="text" name="rt_email" value="<?php if(isset($_POST['rt_email']))  echo $_POST['rt_email'];?>" class="required"	 /> </li>
												<li><label for="phone">Phone Number: (*) </label><input id="phone" type="text" name="rt_phone" value="<?php if(isset($_POST['rt_phone']))  echo $_POST['rt_phone'];?>" class="required" /> </li>
												<li><label for="message">Your message: (*)</label><textarea  id="message" name="rt_message" rows="8" cols="40"	class="required"><?php if(isset($_POST['rt_message'])) { if(function_exists('stripslashes')) { echo stripslashes($_POST['rt_message']); } else { echo $_POST['rt_message']; } } ?></textarea><?php if($commentError != '') { ?>
													<?php echo $commentError;?>
												<?php } ?></li>
												<li><input type="submit" class="button" value="Send"  /></li>
											</ul>
									</form>
								</div>
				    <?php } ?>


			<div class="emptyspace"></div>
			</div>
		<!--/ Page Left-->


         <!-- Page Right-->
			<div id="page_right">
				 <?php 

						//Sidebar For Contact Us
						if (function_exists('dynamic_sidebar') && dynamic_sidebar('Sidebar For Contact Us'));
					
						include(TEMPLATEPATH."/sidebar.php");
				?>          
			</div>
		<!--/  Page Right -->
		<div class="clear_space_h"></div>
		</div>
	</div>
	</div>
	<div class="clear_space"></div>
</div>
<!-- / containers  -->
<?php get_footer();
?>