<?php
/*
Plugin Name: rt-theme6 POST TO BOX WIDGET
Plugin URI: http://themeforest.net/user/stmcan?ref=stmcan
Description: This widget developed for RT- Wordpress Themes. Adds a box with an image and link to sidebars or home page.
Version: 2.0
Author: Tolga can
Author URI: http://themeforest.net/user/stmcan?ref=stmcan
*/

/* RT_THEME_WIDGET Class */
class RT_THEME6_POST_TO_BOX_WIDGET_v2 extends WP_Widget {
    function RT_THEME6_POST_TO_BOX_WIDGET_v2() {
        $widget_ops = array( 'classname' => 'rt-theme6-post-to-box-widget', 'description' => 'Adds blog post as a box with an image and link to sidebars or home page' );
        parent::WP_Widget( 'rt6_posttobox_widget_css', 'RT-THEME 6 POST2BOX', $widget_ops );
    }



    function  widget($args, $instance) {		
		global $more,$post;
        extract( $args );

		if (get_option('rttheme_style')){
			$which_theme=get_option('rttheme_style');
		}else{
			$which_theme="1";		
		}

		$image = apply_filters('image', $instance['image']);
		$slider_second_title = apply_filters('slider_second_title', $instance['slider_second_title']);
		$slider_background_image = apply_filters('slider_background_image', $instance['slider_background_image']);
		$slider_right_image = apply_filters('slider_right_image', $instance['slider_right_image']);
		$slider_text =  apply_filters('text', $instance['text']);


		$rt_post_id = apply_filters('rt_post_id', $instance['rt_post_id']);
        $full_size= apply_filters('full_size', $instance['full_size']);
        $hide_title= apply_filters('hide_title', $instance['hide_title']);

		if ($ID=="Home_Page_Widget" ||  $ID=="Content_Footer_Widget_For_Pages" ||  $ID=="Content_Footer_Widget_For_Portfolio"){$home_page=1;}
		if ($ID=="Slider_Widget"){$slider=1;}


		      	$query_string = "p=$rt_post_id";


      	 		query_posts($query_string);
				if (have_posts()) : 
						while (have_posts()) : the_post(); 
							$title=get_the_title();
							$link=get_permalink();
							$link_text	="read more";
							$more = 0;
						endwhile; 
				endif; 

        ?>

		<?php if ($slider):?>


			<?php if($hide_title):?>
				<!-- slide  1  *** single image sample-->
					<div class="slide">
						<?php if($slider_background_image):?>
							<div class="single_image"><a href="<?php echo $link;?>" title=""><img src="<?php echo $slider_background_image;?>" class="png" alt="" /></a></div>
						<?php endif;?>
					</div>
				<!--/ slide  1-->
			<?php else:?>
				<!-- slide  2  *** with text elements sample-->
				<div class="slide">
						
						<!-- slider background image -->
							<?php if($slider_background_image):?>
								<div class="single_image"><a href="<?php echo $link;?>" title=""><img src="<?php echo $slider_background_image;?>" class="png" alt="" /></a></div>
							<?php else:?>
								<div class="single_image"><img src="<?php bloginfo('template_directory'); ?>/images/pixel.gif" class="png" alt="" /></div>
							<?php endif;?>
						<!-- /slider background image -->


						<!-- sliding text line -->
						<div  class="sliding_text_text"><div class="left_side">
									<!-- title -->
									<h1><a href="<?php echo $link;?>" title=""><?php echo $title;?></a></h1>
									<h2><a href="<?php echo $link;?>"><?php echo $slider_second_title ;?></a></h2>

									<!-- text-->
									<!-- right side slider image-->
									<p><?php  echo $slider_text;?></p>

									</div>
								<?php if($slider_right_image):?>
								<div class="right_side">
									<a href="<?php echo $link;?>" title=""><img src="<?php echo $slider_right_image;?>" class="border png" alt="" /></a>
								</div>
								<?php endif;?>
						</div></div>
						<!-- /sliding text line -->
				<!--/ slide  2-->
			<?php endif;?>


		<?php else:?>

				<?php 
				if(!$home_page){
					$sub_page_class="middle";
					$box_image_width="259";		
				}else{
					$box_image_width="290";				
					$box_image_height="124";		
				}
				?>

				<!-- rt-theme box -->
				<!-- box -->
					<div class="box <?php echo $sub_page_class;?>" <?php if($home_page && $full_size): ?>	style="display:block;clear:both;width:100%;"	<?php endif;?>>
					<?php if($image):?>
						<div class="imgarea">
											<?php if($link): ?><a href="<?php echo $link;?>" title=""><?php endif;?> 
												<?php if(!get_option('rttheme_auto_disable_box')):?>
													<img src="<?php bloginfo('template_directory'); ?>/timthumb.php?src=<?php echo $image;?>&amp;w=<?php echo $box_image_width;?>&amp;h=<?php echo $box_image_height;?>&amp;zc=1" alt="" class="image" />
												<?php else:?>
													<img src="<?php echo $image;?>" alt="" class="image" />
												<?php endif;?>
											<?php if($link): ?></a><?php endif;?>
						</div>
					<?php endif;?>
							<?php if($text!="" || $link!="" || $title!="" || $link_text!=""): ?>		
								<div class="textarea">
									<?php if($title): ?>
										<!-- box title-->
										<h2><?php echo $title;?></h2>
									<?php endif;?>
									<!-- text-->
									 <?php 
										the_excerpt();
									 ?>
									<a class="read_more" href="<?php echo get_permalink($post->ID);?>" title="">read more</a>
								</div>
							<?php endif;?>
					</div>
				<!-- /box -->
				<!-- / rt-theme  box -->

		<?php endif;
		
		wp_reset_query();
		
		?>
    <?php
    }
    
    
    function update($new_instance, $old_instance) {				
        return $new_instance;
    }

    function form($instance) {				

			global $post;
		    $rt_post_id = esc_attr($instance['rt_post_id']);
			$rt_getposts = get_posts('numberposts=-1');
			$full_size= esc_attr($instance['full_size']);
			$hide_title= esc_attr($instance['hide_title']);
			$text = esc_attr($instance['text']);

			$image = esc_attr($instance['image']);
			$slider_second_title = esc_attr($instance['slider_second_title']);
			$slider_background_image = esc_attr($instance['slider_background_image']);
			$slider_right_image = esc_attr($instance['slider_right_image']);


        ?>


		<b>Box Options</b><br />
		<small>You can use these options if you are using this box for home page or side bars!</small> 	<br />	<br />
		<p>

		<label <?php echo $this->get_field_name('rt_post_id'); ?>>
		<small>Please choose a post for content!<br /></small>
		<select  name="<?php echo $this->get_field_name('rt_post_id'); ?>"  id="<?php echo $this->get_field_id('rt_post_id'); ?>" style="width:225px;" >
				<?php foreach ($rt_getposts as $post) { ?>
			<option value="<?php echo $post->ID;?>" <?php if ( $rt_post_id  ==  $post->ID) { echo ' selected="selected" '; }?>><?php echo  the_title(); ?></option>
			<?php } ?>
		</select>
		</label>
		<p>
		<label for="<?php echo $this->get_field_id('image'); ?>"><small><?php _e('Box Image:'); ?></small></label><input class="widefat" id="<?php echo $this->get_field_id('image'); ?>" name="<?php echo $this->get_field_name('image'); ?>" type="text" value="<?php echo $image; ?>" style="width:160px;" /><input  class="rttheme_upload_button <?php echo $this->get_field_id('image'); ?> button"  type="button" value="Upload" />
		</p>

		<br />
		<b>Box Size</b><br />
		<small>You can use this box in single line if you are using for home page!</small> 
		<p>
		<table>
		<tr>
			<td><label for="<?php echo $this->get_field_id('full_size'); ?>"><small><?php _e('full width box:'); ?></small></label></td>
			<td><input  id="<?php echo $this->get_field_id('full_size'); ?>"   <?php if($full_size=='on') echo "checked";?>  name="<?php echo $this->get_field_name('full_size'); ?>" type="checkbox"> </td>
		</tr>
		</table></p>
		<br />
		<hr class="widefat" />
		<br />
		<b>Slider Options</b><br />
		<small>You can use these options if you are using this box for home page slider!</small> 	<br />	<br />

		<p><label for="<?php echo $this->get_field_id('slider_second_title'); ?>"><small><?php _e('Second Title For Slider:'); ?> </small><input class="widefat" id="<?php echo $this->get_field_id('slider_second_title'); ?>" name="<?php echo $this->get_field_name('slider_second_title'); ?>" type="text" value="<?php echo $slider_second_title; ?>" /></label></p>

		<p><label for="<?php echo $this->get_field_id('text'); ?>"><small><?php _e('Text:'); ?></small><br />
		<textarea class="widefat" id="<?php echo $this->get_field_id('text'); ?>" name="<?php echo $this->get_field_name('text'); ?>"><?php echo $text; ?></textarea>
		</label></p>

		<p><label for="<?php echo $this->get_field_id('slider_background_image'); ?>"><small><?php _e('Image For Slider Background: <br /> (950px  211px)'); ?> </small></label><input class="widefat" id="<?php echo $this->get_field_id('slider_background_image'); ?>" name="<?php echo $this->get_field_name('slider_background_image'); ?>" type="text" value="<?php echo $slider_background_image; ?>" style="width:160px;" /><input  class="rttheme_upload_button <?php echo $this->get_field_id('slider_background_image'); ?> button"  type="button" value="Upload" /></p>

		<p><label for="<?php echo $this->get_field_id('slider_right_image'); ?>"><small><?php _e('Right Image For Slider: <br /> (max: 390px  169px)'); ?> </small></label><input class="widefat" id="<?php echo $this->get_field_id('slider_right_image'); ?>" name="<?php echo $this->get_field_name('slider_right_image'); ?>" type="text" value="<?php echo $slider_right_image; ?>" style="width:160px;" /><input  class="rttheme_upload_button <?php echo $this->get_field_id('slider_right_image'); ?> button"  type="button" value="Upload" /></p>

		<table>
		<tr>
			<td valign="top" style="padding-top:4px;padding-right:10px;"><input  id="<?php echo $this->get_field_id('hide_title'); ?>"   <?php if($hide_title=='on') echo "checked";?> name="<?php echo $this->get_field_name('hide_title'); ?>" type="checkbox"> </td>
			<td  valign="top"><label for="<?php echo $this->get_field_id('hide_title'); ?>"><small><?php _e('Hide title and content, display just background image'); ?></small></label></td>
		</tr>
		</table></p>

<?php // end class
}
}
?>
<?php // register RT_THEME6_POST_TO_BOX_WIDGET_v2 widget
add_action('widgets_init', create_function('', 'return register_widget("RT_THEME6_POST_TO_BOX_WIDGET_v2");'));
?>