<?php
/*
Plugin Name: rt-theme6 BOX WIDGET
Plugin URI: http://themeforest.net/user/stmcan?ref=stmcan
Description: This widget developed for RT- Wordpress Themes. Adds a box with an image and link to sidebars or home page.
Version: 2.0
Author: Tolga can
Author URI: http://themeforest.net/user/stmcan?ref=stmcan
*/

/* RT_THEME6_WIDGET Class */
class RT_THEME6_WIDGET_v2 extends WP_Widget {
    function RT_THEME6_WIDGET_v2() {
        $widget_ops = array( 'classname' => 'rt-theme6-widget', 'description' => 'Adds a box with an image and link to sidebars or home page' );
        parent::WP_Widget( 'css-class', 'RT-THEME 6 BOX', $widget_ops );
    }




    function widget($args, $instance) {		
        extract( $args );
		if (get_option('rttheme_style')){
			$which_theme=get_option('rttheme_style');
		}else{
			$which_theme="1";		
		}

        $title = apply_filters('title', $instance['title']);
		$slider_second_title=apply_filters('slider_second_title', $instance['slider_second_title']);
        $image = apply_filters('image', $instance['image']);

		//in slider options
		$slider_background_image=apply_filters('slider_background_image', $instance['slider_background_image']); 
		$slider_right_image=apply_filters('slider_right_image', $instance['slider_right_image']); 


        $text = apply_filters('text', $instance['text']);
        $link = apply_filters('link', $instance['link']);
        $link_text = apply_filters('link_text', $instance['link_text']);
        $target_page = apply_filters('target_page', $instance['target_page']); if($target_page) if($target_page=='on') $open_page='target="_blank"';
        $full_size= apply_filters('full_size', $instance['full_size']);
		if ($ID=="Home_Page_Widget" ||  $ID=="Content_Footer_Widget_For_Pages" ||  $ID=="Content_Footer_Widget_For_Portfolio"){$home_page=1;}
		if ($ID=="Slider_Widget"){$slider=1;}

        ?>

		<?php if ($slider):?>
			<?php if($slider_background_image && !$text && !$slider_right_image && !$text && !$link_text ):?>
				<!-- slide  1  *** single image sample-->
				<div class="slide">
						<!-- sliding text line -->
									<?php if($slider_background_image):?><div class="single_image"><?php if($link):?><a href="<?php echo $link;?>" title=""><?php endif;?>
									<img src="<?php echo $slider_background_image;?>" class="png" alt="" />
									<?php if($link):?></a><?php endif;?></div>
									<?php endif;?>
						<!-- /sliding text line -->
				</div>
				<!--/ slide  1-->
			<?php else:?>
			<!-- slide  2  *** with text elements sample-->
			<div class="slide"><?php if($slider_background_image):?><!-- slider background image -->
			<?php if($link):?><a href="<?php echo $link;?>" title=""><?php endif;?><img src="<?php echo $slider_background_image;?>" class="png" alt="" /><?php if($link):?></a><?php endif;?><!-- /slider background image --><?php else:?><div class="single_image"><img src="<?php bloginfo('template_directory'); ?>/images/pixel.gif" class="png" alt="" /></div><?php endif;?><!-- sliding text line --><div  class="sliding_text_text"><div class="left_side"><!-- title -->
			
			<h1><?php if($link):?><a href="<?php echo $link;?>" title=""><?php endif;?><?php echo $title;?><?php if($link):?></a><?php endif;?></h1>
			<?php if($slider_second_title):?><h2><?php if($link):?><a href="<?php echo $link;?>" title=""><?php endif;?><?php echo $slider_second_title;?><?php if($link):?></a><?php endif;?></h2><?php endif;?>

			
			<!-- text--><!-- right side slider image--><p><?php  echo $text; ?><?php if($link && $link_text): ?>
			<br /> <a class="read_more" href="<?php echo $link;?>" title="" <?php echo $open_page;?>><?php echo $link_text;?></a>
			<?php endif;?></p>	
			</div><?php if($slider_right_image):?><div class="right_side">
			<?php if($link):?><a href="<?php echo $link;?>" title=""><?php endif;?><img src="<?php echo $slider_right_image;?>" class="border png" alt="" /><?php if($link):?></a><?php endif;?></div><?php endif;?></div></div>
			<?php endif;?>
		<?php else:?>




				<?php 
				if(!$home_page){
					$sub_page_class="middle";
					$box_image_width="259";		
				}else{
					$box_image_width="290";				
					$box_image_height="124";		
				}
				?>

				<!-- rt-theme box -->
				<!-- box -->
					<div class="box <?php echo $sub_page_class;?>" <?php if($home_page && $full_size): ?>	style="display:block;clear:both;width:100%;"	<?php endif;?>>
					<?php if($image):?>
						<div class="imgarea">
											<?php if($link): ?><a href="<?php echo $link;?>" title="" <?php echo $open_page;?>><?php endif;?> 
												<?php if(!get_option('rttheme_auto_disable_box')):?>
													<img src="<?php bloginfo('template_directory'); ?>/timthumb.php?src=<?php echo $image;?>&amp;w=<?php echo $box_image_width;?>&amp;h=<?php echo $box_image_height;?>&amp;zc=1" alt="" class="image" />
												<?php else:?>
													<img src="<?php echo $image;?>" alt="" class="image" />
												<?php endif;?>
											<?php if($link): ?></a><?php endif;?>
						</div>
					<?php endif;?>
							<?php if($text!="" || $link!="" || $title!="" || $link_text!=""): ?>		
								<div class="textarea">
									<?php if($title): ?>
										<!-- box title-->
										<h2><?php echo $title;?></h2>
									<?php endif;?>
									<!-- text-->
									<?php if($text): ?><p><?php echo $text;?><?php endif;?></p>
									 
									<?php if($link && $link_text): ?>		
									<a href="<?php echo $link;?>" class="read_more" title="" <?php echo $open_page;?>><?php echo $link_text;?></a>
									<?php endif;?>									

								</div>
							<?php endif;?>
					</div>
				<!-- /box -->
				<!-- / rt-theme  box -->
		<?php endif;
		
		wp_reset_query();
		?>
    <?php
    }

    function update($new_instance, $old_instance) {				
        return $new_instance;
    }

    function form($instance) {				
        $title = esc_attr($instance['title']);
		$image = esc_attr($instance['image']);
		$text = esc_attr($instance['text']);
		$link = esc_attr($instance['link']);
		$link_text = esc_attr($instance['link_text']);
		$target_page= esc_attr($instance['target_page']);
		$full_size= esc_attr($instance['full_size']);


		$slider_second_title=esc_attr($instance['slider_second_title']); 
		$slider_background_image=esc_attr($instance['slider_background_image']); 
		$slider_right_image=esc_attr($instance['slider_right_image']); 


        ?>
		<p><small>if you don't want to use one of these fields, you can leave it blank!</small></p>
		<p><label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title:'); ?> <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo $title; ?>" /></label></p>

		<p><label for="<?php echo $this->get_field_id('image'); ?>" style="display:block;"><?php _e('Image:'); ?></label> <input class="widefat" id="<?php echo $this->get_field_id('image'); ?>" name="<?php echo $this->get_field_name('image'); ?>" type="text" value="<?php echo $image; ?>" style="width:158px;" /><input  class="rttheme_upload_button <?php echo $this->get_field_id('image'); ?> button"  type="button" value="Upload" /></p>

		<p><label for="<?php echo $this->get_field_id('text'); ?>"><?php _e('Text:'); ?> <br />
		<textarea class="widefat" id="<?php echo $this->get_field_id('text'); ?>" name="<?php echo $this->get_field_name('text'); ?>"><?php echo $text; ?></textarea>
		</label></p>
		<br />
		<hr class="widefat" />
		<br />
		<small>link for image and link text!</small> 
		<br /><br />
		<p><label for="<?php echo $this->get_field_id('link'); ?>"><?php _e('Link (URL):'); ?> <input class="widefat" id="<?php echo $this->get_field_id('link'); ?>" name="<?php echo $this->get_field_name('link'); ?>" type="text" value="<?php echo $link; ?>" /></label></p>
		<p><label for="<?php echo $this->get_field_id('link_text'); ?>"><?php _e('Link text (i.e. \'read more\'):'); ?> <input class="widefat" id="<?php echo $this->get_field_id('link_text'); ?>" name="<?php echo $this->get_field_name('link_text'); ?>" type="text" value="<?php echo $link_text; ?>" /></label></p>
		<p>
		<table>
		<tr>
			<td><label for="<?php echo $this->get_field_id('target_page'); ?>"><?php _e('open in new window/tab:'); ?></label></td>
			<td><input  id="<?php echo $this->get_field_id('target_page'); ?>"   <?php if($target_page=='on') echo "checked";?> class="widefat" name="<?php echo $this->get_field_name('target_page'); ?>" type="checkbox"> </td>
		</tr>
		</table></p>
		<br />
		<hr class="widefat" />
		<br />
		<small>You can use this box in single line if you are using for home page!</small> 
		<p>
		<table>
		<tr>
			<td><label for="<?php echo $this->get_field_id('full_size'); ?>"><?php _e('full width box:'); ?></label></td>
			<td><input  id="<?php echo $this->get_field_id('full_size'); ?>"   <?php if($full_size=='on') echo "checked";?> name="<?php echo $this->get_field_name('full_size'); ?>" type="checkbox"> </td>
		</tr>
		</table></p>		

		<br />
		<hr class="widefat" />
		<br />
		<b>Slider Options</b><br />
		<small>You can use these options if you are using this box for slider!</small> 	<br />	<br />
		<p><label for="<?php echo $this->get_field_id('slider_second_title'); ?>"><small><?php _e('Second Title For Slider:'); ?> </small><input class="widefat" id="<?php echo $this->get_field_id('slider_second_title'); ?>" name="<?php echo $this->get_field_name('slider_second_title'); ?>" type="text" value="<?php echo $slider_second_title; ?>" /></label></p>


		<p><label for="<?php echo $this->get_field_id('slider_background_image'); ?>"><small><?php _e('Image For Slider Background: <br /> (887x295px)'); ?> </small></label><input class="widefat" id="<?php echo $this->get_field_id('slider_background_image'); ?>" name="<?php echo $this->get_field_name('slider_background_image'); ?>" type="text" value="<?php echo $slider_background_image; ?>"  style="width:158px;" /><input  class="rttheme_upload_button <?php echo $this->get_field_id('slider_background_image'); ?> button"  type="button" value="Upload" /></p>

		<p><label for="<?php echo $this->get_field_id('slider_right_image'); ?>"><small><?php _e('Right Image For Slider: <br /> (max: 320x285px)'); ?> </small></label><input class="widefat" id="<?php echo $this->get_field_id('slider_right_image'); ?>" name="<?php echo $this->get_field_name('slider_right_image'); ?>" type="text" value="<?php echo $slider_right_image; ?>"  style="width:160px;" /><input  class="rttheme_upload_button <?php echo $this->get_field_id('slider_right_image'); ?> button"  type="button" value="Upload" />
		
		</p>



<?php // end class
}
}
?>
<?php // register RT_THEME_WIDGET widget
add_action('widgets_init', create_function('', 'return register_widget("RT_THEME6_WIDGET_v2");'));
?>