<?php
include(TEMPLATEPATH.'/rttheme_options/includes.php');

/*
WP 3.0  menu support
*/

if (function_exists('wp_nav_menu')){
	add_action( 'init', 'rt_theme_navigations' );
	
	function rt_theme_navigations() {
		register_nav_menu( 'rt-theme-main-navigation', __( 'RT Theme Main Navigation' ) );
		register_nav_menu( 'rt-theme-top-navigation', __( 'RT Theme Top Navigation' ) ); 
		register_nav_menu( 'rt-theme-footer-navigation', __( 'RT Theme Footer Navigation' ) );
	}
	
	wp_create_nav_menu( 'RT Theme Main Navigation Menu', array( 'slug' => 'rt-theme-main-menu' ) );
	wp_create_nav_menu( 'RT Theme Top Navigation Menu', array( 'slug' => 'rt-theme-top-menu' ) ); 
	wp_create_nav_menu( 'RT Theme Footer Navigation Menu', array( 'slug' => 'rt-theme-footer-menu') );
}

/*
*
* Loading Jquery
*
*/

function rt_theme_load_scripts(){ 
    $template_directory = get_bloginfo('template_directory');
    if (!is_admin()) {//load theme scripts
	   wp_deregister_script( 'jquery' );
	   wp_register_script('jquery','https://ajax.googleapis.com/ajax/libs/jquery/1.4.2/jquery.min.js'); 
	   wp_enqueue_script( 'jquery' ); 
    }
}
add_action('init', 'rt_theme_load_scripts');


/* RT-Theme Custom Paging for portfolio and products */
function rt_custom_post_limits( $limits )
{
	if(is_category()){
		
		$cat=get_query_var('cat');
		
		$porfolio_gallery_categories=split(',',get_option('rttheme_portf_ex_cat[]'));
		foreach ($porfolio_gallery_categories as $p_cat){
			if ($p_cat==$cat){
				$post_per_page=get_option('rttheme_portf_pager');
			}
		}
		
		$product_gallery_categories=split(',',get_option('rttheme_product_list_ex_cat[]'));
		foreach ($product_gallery_categories as $p_cat){
			if ($p_cat==$cat){
				$post_per_page=get_option('rttheme_product_list_pager');
			}
		}
	
		$blogtem_categories=split(',',get_option('rttheme_blog_ex_cat[]'));
		foreach ($blogtem_categories as $p_cat){
			if ($p_cat==$cat){
				$post_per_page=get_option('rttheme_blog_pager');
			}
		}
		
		if($post_per_page>0){	
			$page=get_query_var('paged');
			
			if($page==0 || $page<0)  $page = 1; 
			$start=0;
			$end=0;
	 
			if($page=="" || $page<0){
				$start=0;
				$end=$post_per_page;
			}
			
			elseif($page && $page>1){
				$start=$post_per_page*$page-1;
				$end=$start;
			}else{
				$start=0;
				$end=1;
			}
			
			//  offset
			$offset = ($page - 1) * $post_per_page;
			//new limits
			$limits = " LIMIT $offset, $post_per_page"; 			
		}
	}
	
	return $limits; 
}

add_filter('post_limits', 'rt_custom_post_limits' );



/* Slider Widget */
if ( function_exists('register_sidebar') )
	register_sidebar(array(
		'ID'=> 'Slider_Widget',
        'name' => 'Slider Widget',
        'before_widget' => '<div class="box middle"><div class="textarea">',
        'after_widget' => '</div></div>',
        'before_title' => '<h2>',
        'after_title' => '</h2>',
));

/* Widget For Home Page Boxes */
if ( function_exists('register_sidebar') )
	register_sidebar(array(
		'ID'=> 'Home_Page_Widget',
        'name' => 'Home Page Widget',
        'before_widget' => '<div class="box"><div class="textarea">',
        'after_widget' => '</div></div>',
        'before_title' => '<h2>',
        'after_title' => '</h2>',
));


/* Side Bar For Pages */
if ( function_exists('register_sidebar') )
    register_sidebar(array(
		'ID'=> 'Sidebar_For_Pages',
        'name' => 'Sidebar For Pages',
        'before_widget' => '<div class="box middle"><div class="textarea">',
        'after_widget' => '</div></div>',
        'before_title' => '<h2>',
        'after_title' => '</h2>',
    ));


/*	Side Bar For Blog */
if ( function_exists('register_sidebar') )
	register_sidebar(array(
        'name' => 'Sidebar For Blog',
        'before_widget' => '<div class="box middle"><div class="textarea">',
        'after_widget' => '</div></div>',
        'before_title' => '<h2>',
        'after_title' => '</h2>',
));

/* Sidebar For Contact Us */
if ( function_exists('register_sidebar') )
	register_sidebar(array(
		'ID'=> 'Sidebar_For_Contact_Us',
        'name' => 'Sidebar For Contact Us',
        'before_widget' => '<div class="box middle"><div class="textarea">',
        'after_widget' => '</div></div>',
        'before_title' => '<h2>',
        'after_title' => '</h2>',
));

/* Side Bar For Pages&Blog&Templates */
if ( function_exists('register_sidebar') )
	register_sidebar(array(
        'name' => 'Common Sidebar',
        'before_widget' => '<div class="box middle"><div class="textarea">',
        'after_widget' => '</div></div>',
        'before_title' => '<h2>',
        'after_title' => '</h2>',
));


/* Side Bar For Product List & Product Details*/
if ( function_exists('register_sidebar') )
	register_sidebar(array(
        'name' => 'Sidebar For Products',
        'before_widget' => '<div class="box middle"><div class="textarea">',
        'after_widget' => '</div></div>',
        'before_title' => '<h2>',
        'after_title' => '</h2>',
));




/* RT-Breadcrumb Function */
function rt_breadcrumb(){
	global $taxonomy,$term_slug,$post,$delimiter;
	//Markup
	$delimiter=' \\ ';
	
	//Home Page
	_e('You are here: ', 'rt_theme');
	echo "<a href=\"". get_bloginfo('url') ."\" title=\"". get_bloginfo('name')."\">".__( 'Home', 'rt_theme' )."</a>";

	// page parents function
	function page_parents($parent_page_id,$child_pages){
		global $delimiter;

		$parent_page = get_page($parent_page_id);
		$page_parents = $delimiter."<a href=\"".get_permalink($parent_page->ID)."\" title=\"". get_the_title($parent_page->ID) ."\" >". get_the_title($parent_page->ID) ."</a>" .$child_pages;
 
		if ($parent_page->post_parent) page_parents($parent_page->post_parent,$page_parents);
		
		else echo $page_parents;

	}
	
	
	// term parents function
	function term_parents($term_id,$child_terms){
		global $taxonomy,$delimiter;

		$parent_term = get_term_by('ID',$term_id, $taxonomy);
		$term_parents = $delimiter."<a href=\"".get_term_link($parent_term->slug,$taxonomy)."\" title=\"". $parent_term->name ."\" >". $parent_term->name ."</a>" .$child_terms;
		
		if ($parent_term->parent) term_parents($parent_term -> parent,$term_parents);
		
		else echo $term_parents;
	
	}

	//get start page
	function get_start_page($start_page){
		global $delimiter;
		
		//start page parents
		$get_start_page=get_page($start_page);
		if ($get_start_page -> post_parent){
			page_parents( $get_start_page -> post_parent,''); 
		}
		
		//start page
		if ($start_page) {
			echo  $delimiter."<a href=\"".get_permalink($start_page)."\" title=\"". get_the_title($start_page) ."\" >". get_the_title($start_page) ."</a>";
		}
	}

	//terms
	function term_links(){
		global $taxonomy,$post_type,$term_slug,$delimiter;
		
		//Find start page and define taxonomy names
		if($taxonomy=="product_categories"){
			$start_page=get_option('rttheme_product_list');
		}elseif($taxonomy=="portfolio_categories"){
			$start_page=get_option('rttheme_portf_page');
		}	
		
		//get start page
		if ($start_page) get_start_page($start_page);

 
		$term=get_term_by('slug',$term_slug, $taxonomy);
		
		//parent terms
		if ($term -> parent){
			echo term_parents($term -> parent,'');	 
		} 

		//current term
		echo  $delimiter."<a href=\"".get_term_link($term->slug,$taxonomy)."\" title=\"". $term->name ."\" >". $term->name ."</a>";
	}
	

	
	//Pages
	if ( is_page() ){
		//parent pages
		if ($post -> post_parent){
			page_parents( $post -> post_parent,''); 
		} 
		 
		//current page
		echo  $delimiter ."". $post->post_title;
	}
	

	//Single
	elseif (is_single() && !is_attachment()){ 
		// Get post type
		$post_type = get_post_type();
 
		//Taxonomies
		if($post_type == 'products' || $post_type == 'portfolio'){
	
			term_links();
			//current page
			echo  $delimiter."<a href=\"".get_permalink($yeni_sorgu->ID)."\" title=\"". get_the_title($yeni_sorgu->ID) ."\" >". get_the_title($yeni_sorgu->ID) ."</a>";
			
		}else{
		//Categories

		$category_id = get_the_category($my_query->ID);
		$category_id = $category_id[0]->cat_ID;//only one category can be show in the list  - the first one
			
		//start page
		$start_page=get_option('rttheme_blog_page');

			//portfolio page
			$portfolio_categories=explode(",",get_option('rttheme_portf_ex_cat[]'));
			
			foreach($portfolio_categories as $p_category){
				if($p_category == $category_id) $start_page=get_option('rttheme_portf_page');
			}


			//product page
			$product_categories=explode(",",get_option('rttheme_product_list_ex_cat[]'));
			
			foreach($product_categories as $p_category){
				if($p_category == $category_id) $start_page=get_option('rttheme_product_list');
			}			
		
		//get start page
		if ($start_page) get_start_page($start_page);
		
			echo $delimiter;
			echo get_category_parents($category_id, TRUE, $delimiter, FALSE );				
			echo $post->post_title;
		}

	//Category
	}elseif (is_category()){
		//start page
		$start_page=get_option('rttheme_blog_page');
			
			//portfolio page
			$portfolio_categories=explode(",",get_option('rttheme_portf_ex_cat[]'));
			
			foreach($portfolio_categories as $p_category){
				if($p_category == get_query_var('cat')) $start_page=get_option('rttheme_portf_page');
			}

			//product page
			$product_categories=explode(",",get_option('rttheme_product_list_ex_cat[]'));
			
			foreach($product_categories as $p_category){
				if($p_category == get_query_var('cat')) $start_page=get_option('rttheme_product_list');
			}
			
			
			
		//get start page
		if ($start_page) get_start_page($start_page);
		
			echo $delimiter."".get_category_parents(get_query_var('cat'), TRUE, $delimiter, FALSE);
		
	//Taxonomy
	}elseif (is_tax()){
		term_links();
	} else {
		echo  $delimiter."";
		wp_title('');
	}
	
	wp_reset_query();
	
}

/* Pagination */
function get_pagination($range = 7){
  global $paged, $wp_query;
  if ( !$max_page ) {
    $max_page = $wp_query->max_num_pages;
  }
  if($max_page > 1){
    if(!$paged){
      $paged = 1;
    }
	
	if ($paged > 1){
		echo "<li>";
			previous_posts_link(' &laquo; ');
		echo "</li>";
	}
    if($max_page > $range){
      if($paged < $range){
        for($i = 1; $i <= ($range + 1); $i++){
		  echo "<li";
		  if($i==$paged) echo " class='active'";
		  echo "><a href='" . get_pagenum_link($i) ."'>$i</a>";
          echo "</li>";
        }
      }
      elseif($paged >= ($max_page - ceil(($range/2)))){
        for($i = $max_page - $range; $i <= $max_page; $i++){
		  echo "<li";
		  if($i==$paged) echo " class='active'";
		  echo "><a href='" . get_pagenum_link($i) ."'>$i</a>";
          echo "</li>";
        }
      }
      elseif($paged >= $range && $paged < ($max_page - ceil(($range/2)))){
        for($i = ($paged - ceil($range/2)); $i <= ($paged + ceil(($range/2))); $i++){

		  echo "<li";
		  if($i==$paged) echo " class='active'";
		  echo "><a href='" . get_pagenum_link($i) ."'>$i</a>";
          echo "</li>";

        }
      }
    }
    else{
      for($i = 1; $i <= $max_page; $i++){
		  echo "<li";
		  if($i==$paged) echo " class=\"active\" ";
		  echo "><a href='" . get_pagenum_link($i) ."'>$i</a>";
          echo "</li>";
      }
    }
	if ($paged != $max_page){
		echo "<li>";
		 next_posts_link(' &raquo;  ');
		echo "</li>";
	}

  }
}
?>