<?php

if (!function_exists ('is_admin'))
{
	header('Status: 403 Forbidden');
	header('HTTP/1.1 403 Forbidden');
	exit();
}
elseif (!class_exists('OnPageSEOClient'))
{
	class OnPageSEOClient
	{
		// Instance Variables
		var $options = array();

		// PHP 4 Constructor (For Backwards Compatibility)
		function OnPageSEOClient(&$options)
		{
			$this->__construct(&$options);
			return;
		}

		// PHP 5 Constructor
		function __construct(&$options)
		{
			// Plugin Settings
			$this->options = &$options;

			// Content Filter
			add_filter('the_content', array(&$this, 'contentHandler'));
		}

		function contentHandler($content)
		{
			global $post;

			// Plugin Settings Exist (Plugin Needs To Be Reactivated If Not)
			if($this->options)
			{
				// Get Post/Page Settings
				$metaData = get_post_meta($post->ID, 'onpageseo_post_meta_data', true);

				// Post/Page Settings Exist
				if(is_array($metaData['onpageseo_global_settings']) && isset($metaData['onpageseo_global_settings']['MainKeyword']) && (strlen(trim($metaData['onpageseo_global_settings']['MainKeyword'])) > 0))
				{
					// Get Main Keyword For Post/Page
					$keyword = $metaData['onpageseo_global_settings']['MainKeyword'];

					// Identifies Previously Decorated Keywords
					$marker = 'x0x0x0x0x0x0';

					// Bold
					$boldFont = 1;
					if($this->options['bold_keyword'] && preg_match('/<b>.*\b'.$keyword.'\b.*<\/b>|<strong>.*\b'.$keyword.'\b.*<\/strong>|<span.+style=".*font-weight:\s?bold;?.*">.*\b'.$keyword.'\b.*<\/span>/siU', $content))
					{
						$boldFont = 0;
					}

					if($boldFont)
					{
						switch($this->options['bold_style'])
						{
							case 'b':

								$content = preg_replace('/(?<![><])\b'.$keyword.'\b(?!(.*?"|>|<))/siU', '<b>'.$keyword.'</b>', $content, 1);
								break;

							case 'fontweightbold':

								$content = preg_replace('/(?<![><])\b'.$keyword.'\b(?!(.*?"|>|<))/siU', '<span style="font-weight:bold;">'.$keyword.'</span>', $content, 1);
								break;

							default:

								$content = preg_replace('/(?<![><])\b'.$keyword.'\b(?!(.*?"|>|<))/siU', '<strong>'.$keyword.'</strong>', $content, 1);
								break;								
						}
					}


					// Italic
					$italicFont = 1;
					if($this->options['italic_keyword'] && preg_match('/<i>.*\b'.$keyword.'\b.*<\/i>|<em>.*\b'.$keyword.'\b.*<\/em>|<span.+style=".*font-style:\s?italic;?.*">.*\b'.$keyword.'\b.*<\/span>/siU', $content))
					{
						$italicFont = 0;
					}

					if($italicFont)
					{
						switch($this->options['italic_style'])
						{
							case 'i':

								$content = preg_replace('/(?<![><])\b'.$keyword.'\b(?!(.*?"|>|<))/siU', '<i>'.$keyword.'</i>', $content, 1);
								break;

							case 'fontstyleitalic':

								$content = preg_replace('/(?<![><])\b'.$keyword.'\b(?!(.*?"|>|<))/siU', '<span style="font-style:italic;">'.$keyword.'</span>', $content, 1);
								break;

							default:

									$content = preg_replace('/(?<![><])\b'.$keyword.'\b(?!(.*?"|>|<))/siU', '<em>'.$keyword.'</em>', $content, 1);
									break;								
						}
					}

					// Underline
					$underlineFont = 1;
					if($this->options['underline_keyword'] && preg_match('/<u>.*\b'.$keyword.'\b.*<\/u>|<span.+style=".*text-decoration:\s?underline;?.*">.*\b'.$keyword.'\b.*<\/span>/siU', $content))
					{
						$underlineFont = 0;
					}

					if($underlineFont)
					{
						switch($this->options['underline_style'])
						{
							case 'u':
								$content = preg_replace('/(?<![><])\b'.$keyword.'\b(?!(.*?"|>|<))/siU', '<u>'.$keyword.'</u>', $content, 1);
								break;

							default:
								$content = preg_replace('/(?<![><])\b'.$keyword.'\b(?!(.*?"|>|<))/siU', '<span style="text-decoration:underline;">'.$keyword.'</span>', $content, 1);
								break;						
						}
					}


					// Image ALT Attribute
					if($this->options['image_alt'])
					{
						$content = preg_replace('/<img(.*alt=.*>)/siU', "<img$marker$1", $content);
						$content = preg_replace('/<img /siU', '<img alt="'.$keyword.'" ', $content);
					}

					// Delete Markers
					$content = str_replace($marker, '', $content);

				}
			}

			return $content;
		}
	}
}